import sys
sys.setrecursionlimit(10**6)

n = int(input())
nums = input().split()

class Node:
    __slots__ = ("child", "nums")
    def __init__(self):
        self.child = {}
        self.nums = []

root = Node()


for s in nums:
    node = root
    for ch in s:
        if ch not in node.child:
            node.child[ch] = Node()
        node = node.child[ch]
    node.nums.append(s)

groups = []

def dfs(node)
    child_groups = []
    for child in node.child.values():
        child_groups.extend(dfs(child))
    if node.nums:
        child_groups.append(node.nums)
    return child_groups

groups = dfs(root)


print(len(groups))
for g in groups:
    print(len(g))
    print(" ".join(g))